<?php

App::uses('EvFormBuilderAppController', 'EvFormBuilder.Controller');

class FormResponsesController extends EvFormBuilderAppController {

	public $components = [
		'EvFormBuilder.Forms',
	];

/**
 * Defines the toolbar buttons displayed in admin_index.
 *
 * @return array Toolbar.
 */
	protected function _adminIndexToolbar() {
		$toolbar = parent::_adminIndexToolbar();

		if (isset($toolbar['Add New'])) {
			unset($toolbar['Add New']);
		}

		return $toolbar;
	}

/**
 * Pagination settings for admin_index.
 *
 * @return array Pagination settings.
 */
	protected function _adminIndexPaginate() {
		$Model = $this->{$this->modelClass};

		$paginate = parent::_adminIndexPaginate();

		$paginate['joins'][] = [
			'table' => 'users',
			'alias' => 'UserJoin',
			'conditions' => [
				'UserJoin.id = ' . $Model->alias . '.user_id',
			]
		];

		$paginate['joins'][] = [
			'table' => 'ev_form_builder_forms',
			'alias' => 'FormJoin',
			'conditions' => [
				'FormJoin.id = ' . $Model->alias . '.form_id',
			]
		];

		$paginate['contain'][] = 'Form';
		$paginate['contain'][] = 'User';

		$paginate['order'] = [
			$Model->alias . '.created' => 'DESC',
		];

		return $paginate;
	}

/**
 * Defines which actions are available to each row of the admin_index table results.
 * Removing the delete action as reponses should not be deleteable.
 *
 * @return array
 */
	protected function _adminIndexActions() {
		$actions = parent::_adminIndexActions();

		if (isset($actions['Delete'])) {
			unset($actions['Delete']);
		}

		return $actions;
	}

/**
 * Defines the fields displayed in a filter form.
 *
 * @return array The fields to use in the filter.
 */
	protected function _adminFilterFields() {
		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		$fields = parent::_adminFilterFields();

		$postNameFilterFields = [
			'UserJoin.email' => [
				'label' => 'User',
				'type' => 'string',
				'compare' => [
					'UserJoin.email LIKE' => '%%%s%%',
				],
			],
			'FormJoin.name' => [
				'label' => 'Form',
				'type' => 'string',
				'compare' => [
					'FormJoin.name LIKE' => '%%%s%%',
				],
			],
		];

		$fields = ArrayUtil::addAfter($fields, $modelAlias . '.name', $postNameFilterFields);

		if (isset($fields[$modelAlias . '.name'])) {
			unset($fields[$modelAlias . '.name']);
		}

		return $fields;
	}

/**
 * Defines the columns displayed in the admin_index results table
 * using a columns whitelist.
 *
 * @return array admin_index columns.
 */
	protected function _adminIndexColumns() {
		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		$columns = parent::_adminIndexColumns();

		$preActiveColumns = [
			'User.email' => [
				'type' => 'string',
				'label' => 'User',
			],
			'Form.name' => [
				'type' => 'string',
				'label' => 'Form',
			],
		];

		$columns = ArrayUtil::addAfter($columns, $modelAlias . '.id', $preActiveColumns);

		return $columns;
	}

/**
 * Defines the fields displayed in an admin_form for this model.
 * Defaults to all fields in the db table.
 *
 * @return array Form fields.
 */
	protected function _adminFormFields() {
		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		$fields = parent::_adminFormFields();

		if (isset($fields[$modelAlias . '.form_id'])) {
			$formFields = [
				'Form.name' => [
					'type' => 'string',
					'displayonly' => 'displayonly',
				]
			];

			$fields = ArrayUtil::addAfter($fields, $modelAlias . '.form_id', $formFields);

			unset($fields[$modelAlias . '.form_id']);
		}

		if (isset($fields[$modelAlias . '.user_id'])) {
			$userFields = [
				'User.email' => [
					'type' => 'string',
					'displayonly' => 'displayonly',
				]
			];

			$fields = ArrayUtil::addAfter($fields, $modelAlias . '.user_id', $userFields);

			unset($fields[$modelAlias . '.user_id']);
		}

		return $fields;
	}

/**
 * Defines the buttons in the toolbar displayed on an admin_form
 *
 * @param int $id The id of the current record in the form.
 * @return array
 */
	protected function _adminFormToolbar($id = null) {
		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		$actions = parent::_adminFormToolbar($id);

		if (isset($actions['Add New'])) {
			unset($actions['Add New']);
		}

		if (isset($actions['Delete'])) {
			unset($actions['Delete']);
		}

		return $actions;
	}

/**
 * Manages an admin edit form for this model.
 *
 * @param int $id ID of row to edit.
 * @return void
 */
	public function admin_edit($id = null) {
		$Model = $this->{$this->modelClass};
		$modelAlias = $Model->alias;

		parent::admin_edit($id);

		/*
		 * Loop through the form response associations. For each one load the model and use readForView
		 * to get the data. If model data is found then assign it to the request data.
		 */
		if (!empty($this->request->data['FormResponseAssociation'])) {
			$associationFields = [];
			foreach ($this->request->data['FormResponseAssociation'] as $formResponseAssociation) {
				if (!empty($formResponseAssociation['model']) && !empty($formResponseAssociation['model_id'])) {
					$assocaitionModelClass = $formResponseAssociation['model'];
					list($plugin, $associationModelAlias) = pluginSplit($assocaitionModelClass);

					$this->loadModel($assocaitionModelClass);
					$this->request->data[$associationModelAlias] = $this->Forms->loadFormAssociationData($associationModelAlias, $formResponseAssociation['model_id']);

					$associationFields = $this->_addFormResponseAssociationFields($associationFields, $this->{$associationModelAlias});
				}
			}

			$this->viewVars['fields'] = ArrayUtil::addAfter($this->viewVars['fields'], 'User.email', $associationFields);
		}

		/*
		 * Loop through the question block responses and add a tab for each one. In each tab, display the question responses.
		 * The tab name will come from the question block and the question names will come from the question.
		 */
		if (!empty($this->request->data['QuestionBlockResponse'])) {
			foreach ($this->request->data['QuestionBlockResponse'] as $questionBlockResponseIndex => &$questionBlockResponse) {
				//If the question block hasn't been contained then we don't have enough data to add a tab.
				if (empty($questionBlockResponse['QuestionBlock'])) {
					continue;
				}

				$questionBlock = $questionBlockResponse['QuestionBlock'];

				$questionFields = [];

				if (!empty($questionBlockResponse['QuestionResponse'])) {
					foreach ($questionBlockResponse['QuestionResponse'] as $questionResponseIndex => &$questionResponse) {
						//If the question or question type hasn't been contained then we don't have enough data to add a question.
						if (empty($questionResponse['Question']['QuestionType'])) {
							continue;
						}

						$question = $questionResponse['Question'];
						$questionType = $question['QuestionType'];

						if ($questionType['system_name'] == 'info') {
							continue;
						}

						$questionField = 'QuestionBlockResponse.' . $questionBlockResponseIndex . '.QuestionResponse.' . $questionResponseIndex . '.response';

						$questionFields[$questionField] = [
							'type' => 'string',
							'displayonly' => 'displayonly',
							'label' => $question['name'],
						];

						if (!empty($questionType['is_multiple'])) {
							$multiAnswerResponse = $questionResponse['response'];

							$multiAnswerResponse = json_decode($multiAnswerResponse, true);

							if (!empty($multiAnswerResponse)) {
								$multiAnswerResponse = implode(', ', $multiAnswerResponse);

								$questionResponse['response'] = $multiAnswerResponse;
							}
						}
					}
				}

				$this->viewVars['fields']['tabs'][$questionBlock['name']] = $questionFields;
			}
		}
	}

/**
 * Add fields to the admin_edit form for form response associations. Defaults to the display field of the model.
 *
 * @param array $fields Array of fields to use on the admin_edit form.
 * @param Model $Model  The form response association model being added.
 * @return array Array of fields to add to the admin_edit form.
 */
	protected function _addFormResponseAssociationFields($fields, $Model) {
		$modelAlias = $Model->alias;
		$fields[$modelAlias . '.' . $modelAlias . '.' . $Model->displayField] = [
			'type' => 'string',
			'displayonly' => 'displayonly',
			'label' => $modelAlias . ' ' . $Model->displayField,
		];

		return $fields;
	}
}
