<?php

$config = [
	'EvFormBuilder' => [
		/**
		 * If you want to restrict question types then add a list of the system names you want to allow.
		 */
		'restrictQuestionTypes' => [],

		'associationsHaveMultipleForms' => false,

		/**
		 * If you are associating forms or form responses with other models then declare them in an array like:
		 * [
		 *     'Page' => [
		 *         'className' => 'EvCore.Page',
		 *         'contain' => [
		 *             'Template',
		 *             'User' => [
		 *                 'UserGroup',
		 *             ],
		 *         ],
		 *     ],
		 * ]
		 */
		'associations' => null,

		'redirects' => [
			'responseSuccess' => null,
			'responseError' => null,
		],

		/**
		 * Limit the amount of responses a user can make to each form.
		 * A form with different response associations is considered separate.
		 * Setting the value to "-1" would allow unlimited responses.
		 */
		'responseLimit' => -1,

		/**
		 * Define the image slots for Forms, QuestionBlocks and Questions. They will automatically attached to the
		 * admin edit for each model and pulled out when using readForSubmit().
		 */
		'imageSlots' => [
			'Form' => [],
			'QuestionBlock' => [],
			'Question' => [],
		],
	],
];
