<?php

App::uses('MigrationUtil', 'EvMigrationUtil.Lib');

class SaveFormReponseAdminMenuItem extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'save_form_response_admin_menu_item';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
		),
		'down' => array(
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		$MenuMigrationUtil = MigrationUtil::init('EvNavigation.Menu');

		if ($direction == 'up') {
			//Form parent
			$MenuMigrationUtil->createOnceWithParent(
				[
					'plugin' => 'EvFormBuilder',
					'controller' => 'ev_form_builder.form_responses',
					'model' => 'FormRespose',
					'action' => 'index',
				],
				[
					'name' => 'Admin',
					'parent_id' => null,
				],
				[
					'name' => 'Form Responses',
					'pattern' => '/^\/admin\/ev_form_builder\/form_responses\//',
					'plugin' => 'EvFormBuilder',
					'controller' => 'ev_form_builder.form_responses',
					'model' => 'Form',
					'action' => 'index',
					'class' => 'icon-envelope-o',
					'permission_level' => 20,
					'is_active' => true,
				]
			);
		} else {
			//Forms
			$MenuMigrationUtil->deleteAllWithParent(
				[
					'plugin' => 'EvFormBuilder',
					'controller' => 'ev_form_builder.form_responses',
					'model' => 'FormResponse',
					'action' => 'index',
				],
				[
					'name' => 'Admin',
					'parent_id' => null,
				]
			);
		}

		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
