<?php

App::uses('MigrationUtil', 'EvMigrationUtil.Lib');

class AddInternalNamesToFormsQuestionBlocksAndQuestions extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'add_internal_names_to_forms_question_blocks_and_questions';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'ev_form_builder_forms' => array(
					'internal_name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4', 'after' => 'name'),
				),
				'ev_form_builder_question_blocks' => array(
					'internal_name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4', 'after' => 'name'),
				),
				'ev_form_builder_questions' => array(
					'internal_name' => array('type' => 'string', 'null' => true, 'default' => null, 'length' => 250, 'collate' => 'utf8mb4_general_ci', 'charset' => 'utf8mb4', 'after' => 'name'),
				),
			),
		),
		'down' => array(
			'drop_field' => array(
				'ev_form_builder_forms' => array(
					'internal_name',
				),
				'ev_form_builder_question_blocks' => array(
					'internal_name',
				),
				'ev_form_builder_questions' => array(
					'internal_name',
				),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
