<?php

App::uses('MigrationUtil', 'EvMigrationUtil.Lib');

class SaveRadioQuestionType extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'save_radio_question_type';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
		),
		'down' => array(
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		$QuestionTypeUtil = MigrationUtil::init('EvFormBuilder.QuestionType');

		if ($direction == 'up') {
			$QuestionTypeUtil->createOnce(
				[
					'system_name' => 'radio'
				],
				[
					'name' => 'Radio',
					'system_name' => 'radio',
					'input_type' => 'radio',
					'is_multiple' => true,
					'can_have_answers' => true,
					'can_be_required' => true,
				]
			);
		} else {
			$QuestionTypeUtil->deleteIfExists(
				[
					'system_name' => 'radio',
				]
			);
		}

		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
