<?php

App::uses('MigrationUtil', 'EvMigrationUtil.Lib');

class SaveFormResponseSuccessPage extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'save_form_response_success_page';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
		),
		'down' => array(
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		$PageMigrationUtil = MigrationUtil::init('EvCore.Page');

		if ($direction == 'up') {
			$PageMigrationUtil->createOnce(
				[
					'internal_title' => 'Form Response Success',
				],
				[
					'title' => 'Response Saved',
					'internal_title' => 'Form Response Success',
					'is_active' => true,
					'is_protected' => true,
				]
			);
		} else {
			$PageMigrationUtil->updateSingle(
				[
					'internal_title' => 'Form Response Success',
				],
				[
					'is_protected' => false,
				]
			);

			$PageMigrationUtil->deleteIfExists(
				[
					'internal_title' => 'Form Response Success',
				]
			);
		}

		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
