<?php

App::uses('MigrationUtil', 'EvMigrationUtil.Lib');

class AddIsMultipleToQuestionTypes extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'add_is_multiple_to_question_types';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
			'create_field' => array(
				'ev_form_builder_question_types' => array(
					'is_multiple' => array('type' => 'boolean', 'null' => false, 'default' => false, 'after' => 'input_type'),
				),
			),
		),
		'down' => array(
			'drop_field' => array(
				'ev_form_builder_question_types' => array(
					'is_multiple',
				),
			),
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		$QuestionTypeMigrationUtil = MigrationUtil::init('EvFormBuilder.QuestionType');

		if ($direction == 'up') {
			$QuestionTypeMigrationUtil->updateMultiple(
				[
					'system_name'
				],
				[
					[
						'system_name' => 'checkbox',
						'is_multiple' => true,
					],
					[
						'system_name' => 'yesno',
						'is_multiple' => true,
					],
					[
						'system_name' => 'select',
						'is_multiple' => true,
					],
				]
			);
		}

		return true;
	}
}
