<?php

App::uses('MigrationUtil', 'EvMigrationUtil.Lib');

class SaveFormBuilderAdminMenus extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'save_form_builder_admin_menus';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
		),
		'down' => array(
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		$MenuMigrationUtil = MigrationUtil::init('EvNavigation.Menu');

		if ($direction == 'up') {
			//Form parent
			$MenuMigrationUtil->createOnceWithParent(
				[
					'plugin' => 'EvFormBuilder',
					'controller' => 'ev_form_builder.forms',
					'model' => 'Form',
					'action' => 'index',
				],
				[
					'name' => 'Admin',
					'parent_id' => null,
				],
				[
					'name' => 'Forms',
					'pattern' => '/^\/admin\/ev_form_builder\/forms\//',
					'plugin' => 'EvFormBuilder',
					'controller' => 'ev_form_builder.forms',
					'model' => 'Form',
					'action' => 'index',
					'class' => 'icon-pencil-square-o',
					'permission_level' => 20,
					'is_active' => true,
				]
			);

			//Question blocks
			$MenuMigrationUtil->createOnceWithParent(
				[
					'plugin' => 'EvFormBuilder',
					'controller' => 'ev_form_builder.question_blocks',
					'model' => 'QuestionBlock',
					'action' => 'index',
				],
				[
					'plugin' => 'EvFormBuilder',
					'controller' => 'ev_form_builder.forms',
					'model' => 'Form',
					'action' => 'index',
				],
				[
					'name' => 'Question Blocks',
					'pattern' => '/^\/admin\/ev_form_builder\/forms\//',
					'plugin' => 'EvFormBuilder',
					'controller' => 'ev_form_builder.question_blocks',
					'model' => 'QuestionBlock',
					'action' => 'index',
					'permission_level' => 20,
					'is_active' => true,
				]
			);

			//Questions
			$MenuMigrationUtil->createOnceWithParent(
				[
					'plugin' => 'EvFormBuilder',
					'controller' => 'ev_form_builder.questions',
					'model' => 'Question',
					'action' => 'index',
				],
				[
					'plugin' => 'EvFormBuilder',
					'controller' => 'ev_form_builder.forms',
					'model' => 'Form',
					'action' => 'index',
				],
				[
					'name' => 'Questions',
					'pattern' => '/^\/admin\/ev_form_builder\/forms\//',
					'plugin' => 'EvFormBuilder',
					'controller' => 'ev_form_builder.questions',
					'model' => 'Question',
					'action' => 'index',
					'permission_level' => 20,
					'is_active' => true,
				]
			);
		} else {
			//Questions
			$MenuMigrationUtil->deleteAllWithParent(
				[
					'plugin' => 'EvFormBuilder',
					'controller' => 'ev_form_builder.questions',
					'model' => 'Question',
					'action' => 'index',
				],
				[
					'plugin' => 'EvFormBuilder',
					'controller' => 'ev_form_builder.forms',
					'model' => 'Form',
					'action' => 'index',
				]
			);

			//Question Blocks
			$MenuMigrationUtil->deleteAllWithParent(
				[
					'plugin' => 'EvFormBuilder',
					'controller' => 'ev_form_builder.question_blocks',
					'model' => 'QuestionBlock',
					'action' => 'index',
				],
				[
					'plugin' => 'EvFormBuilder',
					'controller' => 'ev_form_builder.forms',
					'model' => 'Form',
					'action' => 'index',
				]
			);

			//Forms
			$MenuMigrationUtil->deleteAllWithParent(
				[
					'plugin' => 'EvFormBuilder',
					'controller' => 'ev_form_builder.forms',
					'model' => 'Form',
					'action' => 'index',
				],
				[
					'name' => 'Admin',
					'parent_id' => null,
				]
			);
		}

		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
