<?php

App::uses('MigrationUtil', 'EvMigrationUtil.Lib');

class SaveDefaultQuestionTypes extends CakeMigration {

/**
 * Migration description
 *
 * @var string
 */
	public $description = 'save_default_question_types';

/**
 * Actions to be performed
 *
 * @var array $migration
 */
	public $migration = array(
		'up' => array(
		),
		'down' => array(
		),
	);

/**
 * Before migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function before($direction) {
		$QuestionTypeUtil = MigrationUtil::init('EvFormBuilder.QuestionType');

		if ($direction == 'up') {
			$QuestionTypeUtil->createAllOnce(
				[
					'system_name'
				],
				[
					[
						'name' => 'Short text',
						'system_name' => 'text',
						'input_type' => 'text',
						'can_have_answers' => false,
						'can_be_required' => true,
					],
					[
						'name' => 'Long text',
						'system_name' => 'textarea',
						'input_type' => 'textarea',
						'can_have_answers' => false,
						'can_be_required' => true,
					],
					[
						'name' => 'Information',
						'system_name' => 'info',
						'input_type' => null,
						'can_have_answers' => false,
						'can_be_required' => false,
					],
					[
						'name' => 'Checkbox',
						'system_name' => 'checkbox',
						'input_type' => 'checkbox',
						'can_have_answers' => true,
						'can_be_required' => true,
					],
					[
						'name' => 'Yes/No',
						'system_name' => 'yesno',
						'input_type' => 'radio',
						'default_options' => 'yes,no',
						'can_have_answers' => false,
						'can_be_required' => true,
					],
					[
						'name' => 'Single select',
						'system_name' => 'select',
						'input_type' => 'select',
						'can_have_answers' => true,
						'can_be_required' => true,
					],
				]
			);
		} else {
			$QuestionTypeUtil->deleteAll(
				[
					'system_name' => [
						'text',
						'textarea',
						'info',
						'checkbox',
						'yesno',
						'select',
					],
				]
			);
		}

		return true;
	}

/**
 * After migration callback
 *
 * @param string $direction Direction of migration process (up or down)
 * @return bool Should process continue
 */
	public function after($direction) {
		return true;
	}
}
