<?php
App::uses('EvFiltersAppModel', 'EvFilters.Model');

class FilterGroupOption extends EvFiltersAppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'name';

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'name' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				'message' => 'Please enter the option name',
			),
		),
		'filter_group_id' => array(
			'numeric' => array(
				'rule' => array('numeric'),
				'message' => 'Please select the associated option group',
			),
		),
	);

	// The Associations below have been created with all possible keys, those that are not needed can be removed

/**
 * belongsTo associations
 *
 * @var array
 */
	public $belongsTo = array(
		'FilterGroup' => array(
			'className' => 'EvFilters.FilterGroup',
			'foreignKey' => 'filter_group_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)
	);

/**
 * hasAndBelongsToMany associations
 *
 * @var array
 */
	public $hasAndBelongsToMany = array(
		'Option' => array(
			'className' => 'EvShop.Option',
			'joinTable' => 'ev_filters_filter_group_options_ev_shop_options',
			'foreignKey' => 'filter_group_option_id',
			'associationForeignKey' => 'option_id',
			'unique' => 'keepExisting',
			'conditions' => '',
			'fields' => '',
			'order' => '',
			'limit' => '',
			'offset' => '',
			'finderQuery' => '',
		)
	);

	public function readForEdit($id, $params = array()) {
		$params['contain'][] = 'Option';

		return parent::readForEdit($id, $params);
	}
}
