<?php
App::uses('EvFiltersAppModel', 'EvFilters.Model');

class FilterGroup extends EvFiltersAppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'name';

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'name' => array(
			'notBlank' => array(
				'rule' => array('notBlank'),
				'message' => 'Please enter the filter group name',
			),
		),
	);

	// The Associations below have been created with all possible keys, those that are not needed can be removed

/**
 * belongsTo associations
 *
 * @var array
 */
	public $belongsTo = array(
		'OptionGroup' => array(
			'className' => 'EvShop.OptionGroup',
			'foreignKey' => 'option_group_id'
		)
	);

/**
 * hasMany associations
 *
 * @var array
 */
	public $hasMany = array(
		'FilterGroupOption' => array(
			'className' => 'EvFilters.FilterGroupOption',
			'foreignKey' => 'filter_group_id',
		)
	);

/**
 * Build Filters
 * Combines the current (standard) filters with any enhanced filters
 * Will override with any enhanced filter tagged to a standard filter group
 *
 * @param array $currentFilters - filters currently available for display
 * @return array $filters - combined/overridden filters*
 */
	public function buildGroupFilters($currentFilters) {
		$validOptionIds = Hash::extract( $currentFilters, '{n}[option_group_id].Option.{n}.id');
		$groupFilters = $this->find('all', array(
			'joins' => [
				[
					'table' => 'ev_filters_filter_group_options',
					'type' => 'INNER',
					'alias' => 'FilterGroupOption',
					'conditions' => [
						'FilterGroupOption.filter_group_id = FilterGroup.id'
					]
				],
				[
					'table' => 'ev_filters_filter_group_options_ev_shop_options',
					'alias' => 'FilterGroupOptionOption',
					'type' => 'INNER',
					'conditions' => [
						'FilterGroupOptionOption.filter_group_option_id = FilterGroupOption.id',
						'FilterGroupOptionOption.option_id' => $validOptionIds
					]
				],
				[
					'table' => 'ev_shop_options',
					'alias' => 'Option',
					'type' => 'INNER',
					'conditions' => [
						'FilterGroupOptionOption.option_id = Option.id'
					]
				],
			],
			'fields' => [
				'FilterGroup.*',
				'FilterGroupOption.*',
				'Option.*'
			],
			'order' => 'FilterGroup.sequence ASC',
		));

		// Add group filter options to the standard filters.
		foreach ($currentFilters as $currentFilterIndex => $currentFilter) {
			foreach ($groupFilters as $groupFilterIndex => $groupFilter) {
				if (isset($currentFilter['option_group_id']) && $groupFilter['FilterGroup']['option_group_id'] == $currentFilter['option_group_id']) {
					if (empty($currentFilters[$currentFilterIndex]['FilterGroup'])) {
						$currentFilters[$currentFilterIndex]['FilterGroup'] = $groupFilter['FilterGroup'];
					}
					if (empty($currentFilters[$currentFilterIndex]['FilterGroupOption'][$groupFilter['FilterGroupOption']['id']])) {
						$currentFilters[$currentFilterIndex]['FilterGroupOption'][$groupFilter['FilterGroupOption']['id']] = $groupFilter['FilterGroupOption'];
					}
					$currentFilters[$currentFilterIndex]['FilterGroupOption'][$groupFilter['FilterGroupOption']['id']]['Option'][] = $groupFilter['Option'];
				}
			}
		}

		return $currentFilters;
	}
}
