<?php

App::uses('EvFiltersAppController', 'EvFilters.Controller');

class FilterGroupOptionsController extends EvFiltersAppController {

	protected function _adminPopulateLookups() {
		$this->set('filterGroups', $this->FilterGroupOption->FilterGroup->find('list'));
		$this->set('options', $this->FilterGroupOption->Option->find('list', array(
			'joins' => array(
				array(
					'table' => 'ev_shop_option_groups',
					'alias' => 'OptionGroup',
					'conditions' => 'Option.option_group_id = OptionGroup.id'
				)
			),
			'fields' => array(
				'Option.id',
				'Option.name',
				'OptionGroup.name'
			),
			'order' => 'OptionGroup.name ASC, Option.sequence ASC'
		)));
	}

	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		$fields['Option'] = array(
			'type' => 'multicheck'
		);

		return $fields;
	}
}