<?php
App::uses('EvFeefoAppModel', 'EvFeefo.Model');
/**
 * EvFeefoReview Model
 *
 */
class Review extends EvFeefoAppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'customer_name';

	public function getRatingByProduct($product) {
		$results = $this->find('all', array(
			'conditions' => array(
				'Review.product LIKE' => '%' . $product . '%'
			)
		));

		$avgRating = 0;

		if (! empty($results)) {
			$ratings = [];

			foreach ($results as $rating) {
				$ratings[] = $rating['Review']['rating'];
			}

			$avgRating = array_sum($ratings) / count($ratings);
		}

		return $avgRating;
	}


}
