<?php
App::uses('HttpSocket', 'Network/Http');


class FeefoApi {

	public $merchantIdentifier;
	public $apiKey;
	public $email;
	public $password;

	public $apiUrl = 'https://api.feefo.com/api/';

	public $api;

	public function __construct($merchantIdentifier, $apiKey, $email, $password) {
		$this->merchantIdentifier = $merchantIdentifier;
		$this->apiKey = $apiKey;
		$this->email = $email;
		$this->password = $password;
	}

	public function auth() {

		$params = array(
			'authenticationDTO' => array(
				'merchantIdentifier' => $this->merchantIdentifier,
				'apiKey' => $this->apiKey,
				'username' => $this->email,
				'password' => $this->password
			)
		);

		$result = $this->request('apiauthenticate', $params, 'post');
		pr($result);
	}

	public function getReviews($limit = 3) {

		$params = array(
			'merchant_identifier' => $this->merchantIdentifier,
		);

		$result = $this->request('10/reviews/service', $params);

		$data = json_decode($result->body);

		$reviews = array();

		$i = 0;

		foreach ($data->reviews as $review) {
			if ($i <= $limit) {

				$reviews[] = array(
					'url ' => $review->url,
					'customer_name' => (! empty($review->customer->display_name) ? $review->customer->display_name : null),
					'location' => (! empty($review->customer->location) ? $review->customer->location : null),
					'rating_min' => $review->service->rating->min,
					'rating_max' => $review->service->rating->max,
					'rating' => $review->service->rating->rating,
					'product' => (! empty($review->products_purchased[0]) ? $review->products_purchased[0] : null),
					'review' => $review->service->review
				);
				$i++;
			}
		}
		return $reviews;
	}

	private function request($endpoint, $params, $type = 'get') {
		$request = new HttpSocket();

		if ($type == 'get') {
			return $request->get($this->apiUrl . $endpoint, $params);
		} elseif ($type == 'post') {
			return $request->get($this->apiUrl . $endpoint, $params);
		}
	}

}
