<?php
App::uses('QueueTask', 'Queue.Console/Command/Task');

class QueueUpdateReviewsTask extends QueueTask {

/**
 * Adds the reviews task to the queued tasks
 *
 * @return void
 */
	public function add() {
		$QueuedTask = EvClassRegistry::init('Queue.QueuedTask');
		$QueuedTask->createJob('UpdateReviews');
	}

/**
 * Makes a call to Feefo to retreive merchant reviews before saving them
 * to the app database
 *
 * @param array $data The array passed to QueuedTask->createJob()
 * @param int $id The id of the QueuedTask
 * @return bool Success
 */
	public function run($data, $id = null) {
		$feefo = new Evoluted\Feefo\Feefo(
			Configure::read('EvFeefo.merchantIdentifier'),
			Configure::read('EvFeefo.apiKey')
		);

		$Review = EvClassRegistry::init('EvFeefo.Review');

		$Review->deleteAll(['1 = 1']);

		$pages = 5;

		$data = [];

		for ($i = 1; $i <= $pages; $i++) {
			$reviews = $feefo->get('10/reviews/service', [
				'merchant_identifier' => $feefo->merchantIdentifier,
				'page_size' => '100',
				'page' => $i
			]);

			if (! empty($reviews->reviews)) {
				foreach ($reviews->reviews as $review) {
					$data[] = [
						'url ' => $review->url,
						'customer_name' => (! empty($review->customer->display_name) ? $review->customer->display_name : null),
						'location' => (! empty($review->customer->display_location) ? $review->customer->display_location : null),
						'rating_min' => $review->service->rating->min,
						'rating_max' => $review->service->rating->max,
						'rating' => $review->service->rating->rating,
						'product' => (! empty($review->products_purchased[0]) ? $review->products_purchased[0] : null),
						'title' => (! empty($review->service->title) ? $review->service->title : null),
						'date' => $review->service->created_at,
						'review' => $review->service->review
					];
				}
			}
		}

		$Review->saveMany($data);
		return true;
	}

}
