<?php
App::uses('QueueTask', 'Queue.Console/Command/Task');

class QueueUpdateRatingsTask extends QueueTask {

/**
 * Adds the reviews task to the queued tasks
 *
 * @return void
 */
	public function add() {
		$QueuedTask = EvClassRegistry::init('Queue.QueuedTask');
		$QueuedTask->createJob('UpdateRatings');
	}

/**
 * Makes a call to Feefo to retreive merchant ratings before saving them
 * to the app database
 *
 * @param array $data The array passed to QueuedTask->createJob()
 * @param int $id The id of the QueuedTask
 * @return bool Success
 */
	public function run($data, $id = null) {
		$feefo = new Evoluted\Feefo\Feefo(
			Configure::read('EvFeefo.merchantIdentifier'),
			Configure::read('EvFeefo.apiKey')
		);

		$Rating = EvClassRegistry::init('EvFeefo.Rating');

		$Rating->deleteAll(['1 = 1']);

		$pages = 5;

		$data = [];

		for ($i = 1; $i <= $pages; $i++) {
			$ratings = $feefo->get('10/products/ratings', [
				'merchant_identifier' => $feefo->merchantIdentifier,
				'page_size' => '100',
				'page' => $i,
				'since' => 'year'
			]);

			if (! empty($ratings->products)) {
				foreach ($ratings->products as $rating) {
					$data[] = [
						'vendor_ref ' => $rating->vendor_ref,
						'rating' => (! empty($rating->rating) ? $rating->rating : null)
					];
				}
			}
		}

		$Rating->saveMany($data);
		return true;
	}
}
