<?php

App::uses('FaqsAppModel', 'Faqs.Model');

class FaqCategory extends FaqsAppModel {

	public $actsAs = [
		'Routable.Routable' => [
			'config' => 'Faqs',
			'alias' => 'faqs/:displayField',
		],
	];

	public $hasMany = [
		'Faq' => [
			'className' => 'Faqs.Faq',
		],
	];

	public $order = [
		'FaqCategory.sequence' => 'asc',
		'FaqCategory.name' => 'asc'
	];

/**
 * Query used to retrieve a record ready for view.
 * By default calls readForEdit but can be extended to bring out more complicated data.
 * Use `readForViewOrFail` instead of this method to throw an exception if no record is found.
 *
 * @param int|string $id Primary key
 * @param array $params The db query array - can be used to pass in additional parameters such as contain
 * @return array
 */
	public function readForView($id, $params = []) {
		//Include faq contains if not specified.
		if (empty($params['contain']) || !in_array('Faq', $params['contain'])) {
			$params['contain'][] = 'Faq';
		}

		return parent::readForView($id, $params);
	}

/**
 * Get a list of faq categories to use as a menu.
 *
 * @param array $query Custom query parameters.
 * @return array The found faq categories.
 */
	public function getForMenu($query = []) {
		$query['conditions'][$this->alias . '.is_active'] = true;
		$query['order'][$this->alias . '.sequence'] = 'ASC';

		return $this->find(
			'list',
			$query
		);
	}
}
