<?php

App::uses('FaqsAppController', 'Faqs.Controller');

class FaqsController extends FaqsAppController {

/**
 * Before filter
 *
 * @return void
 */
	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow([
			'index',
		]);
	}

/**
 * FAQs page
 *
 * @return void
 */
	public function index() {
		$Model = $this->{$this->modelClass};

		// Get the page details for headers / meta data
		if (Configure::check('Faqs.page_ids.index')) {
			$this->assignPage(Configure::read('Faqs.page_ids.index'));
		}

		$this->set('faqs', $this->Faq->getFaqs());

		$this->view = 'Faqs.Faqs/index';
	}

/**
 * Populate admin lookups
 *
 * @return void
 */
	protected function _adminPopulateLookups() {
		$Model = $this->{$this->modelClass};
		$faqCategories = $Model->FaqCategory->getForDropDown();
		$this->set(compact('faqCategories'));
	}

/**
 * Defines the fields displayed in a filter form. Defaults to id, display name, is_active, created and modified fields.
 *
 * @return array Admin index filter fields.
 */
	protected function _adminFilterFields() {
		$alias = $this->{$this->modelClass}->alias;

		$fields = parent::_adminFilterFields();

		$additionalFilters = [];

		if (Configure::read('Faqs.has_categories') === true) {
			$additionalFilters[$alias . '.faq_category_id'] = [
				'type' => 'select',
				'label' => 'Category',
				'compare' => [
					$alias . '.faq_category_id' => '%s',
				],
			];
		}

		if (!empty($additionalFilters)) {
			$fields = ArrayUtil::addAfter(
				$fields,
				$alias . '.question',
				$additionalFilters
			);
		}

		return $fields;
	}

/**
 * Pagination settings for admin_index.
 *
 * @return array
 */
	protected function _adminIndexPaginate() {
		$paginate = parent::_adminIndexPaginate();

		if (Configure::read('Faqs.has_categories') === true) {
			$paginate['contain']['FaqCategory'] = [];
		}

		return $paginate;
	}

/**
 * Defines the columns displayed in the admin_index results table using a columns whitelist.
 *
 * @return array Index columns.
 */
	protected function _adminIndexColumns() {
		$alias = $this->{$this->modelClass}->alias;

		$columns = parent::_adminIndexColumns();

		$additionalColumns = [];

		if (Configure::read('Faqs.has_categories') === true) {
			$additionalColumns['FaqCategory.name'] = [
				'type' => 'string',
				'label' => 'Category',
			];
		}

		if (!empty($additionalColumns)) {
			$columns = ArrayUtil::addAfter(
				$columns,
				$alias . '.answer',
				$additionalColumns
			);
		}

		return $columns;
	}

/**
 * Admin index columns whitelist
 *
 * @return array
 */
	protected function _adminIndexColumnsWhitelist() {
		$columns = parent::_adminIndexColumnsWhitelist();
		$columns[] = 'Faq.answer';
		return $columns;
	}

/**
 * Admin form fields
 *
 * @return array
 */
	protected function _adminFormFields() {
		$formFields = parent::_adminFormFields();

		// if we are not using faq categories then unset the select field
		if (
			Configure::read('Faqs.has_categories') !== true &&
			isset($formFields[$this->{$this->modelClass}->alias . '.faq_category_id'])
		) {
			unset($formFields[$this->{$this->modelClass}->alias . '.faq_category_id']);
		}

		return $formFields;
	}

/**
 * Admin edit
 *
 * @param int $id FAQ ID
 * @return void
 */
	public function admin_edit($id = null) {
		if (Configure::read('Faqs.has_categories') === true) {
			$this->{$this->modelClass}->validate = array_merge(
				$this->{$this->modelClass}->validate,
				[
					'faq_category_id' => [
						'required' => [
							'rule' => 'notBlank',
							'message' => 'Please tag a faq category'
						]
					]
				]
			);
		}

		return parent::admin_edit($id);
	}

}
