<?php

App::uses('FaqsAppController', 'Faqs.Controller');

class FaqCategoriesController extends FaqsAppController {

/**
 * Called before the controller action. You can use this method to configure and customize components
 * or perform logic that needs to happen before each controller action.
 *
 * @return void
 * @link http://book.cakephp.org/2.0/en/controllers.html#request-life-cycle-callbacks
 */
	public function beforeFilter() {
		$this->Auth->allow(
			[
				'view',
			]
		);

		parent::beforeFilter();
	}

/**
 * Defines the fields displayed in an admin_form for this model Defaults to all fields in the db table.
 *
 * @return array The admin form fields.
 */
	protected function _adminFormFields() {
		$Model = $this->{$this->modelClass};

		$fields = parent::_adminFormFields();

		$categoryDescriptions = Configure::read('Faqs.category_descriptions');
		if ($categoryDescriptions === false) {
			unset($fields[$Model->alias . '.description']);
		} elseif (is_string($categoryDescriptions)) {
			$fields[$Model->alias . '.description']['type'] = $categoryDescriptions;
		}

		return $fields;
	}

/**
 * View a FAQ category.
 *
 * @param int $id The FAQ category id.
 * @return void.
 */
	public function view($id) {
		$Model = $this->{$this->modelClass};

		$category = $Model->readForViewOrFail($id);

		$this->set('data', $category);
		$this->set('faqCategories', $Model->getForMenu());

		$this->view = 'Faqs.FaqCategories/view';
	}

}
