EvFacebook Plugin
=================

Authors: Rick Mills


Introduction
------------

EvFacebook provides access to the facebook page feed api. It has been rewritten from the previous version due to the old API being discontinued. This version uses the official Facebook GraphAPI composer package (https://packagist.org/packages/facebook/graph-sdk) and only requires an access token to work.

Installation
------------

This is a composer plugin so from www/app just run composer as:-

	composer require evoluted/facebook


To setup the database use the CakeDC Migrations plugin. To run the migrations and setup the database run:-

	Console/cake Migrations.migration run all --plugin EvFacebook

To setup the plugin's config create a new config file 'app/Config/facebook.php' and copy over the default config from the plugin.


Setting up your Access token
-----------------------------

To use the facebook graph api you need a develper account. You can grab one by going to https://developers.facebook.com. You then want to create a new website app, and it'll provide you with an oauth appid and secret - these need to go into your config file.

API calls need to be done using a short-term token. The plugin already handles issuing the session token for you using the oauth details.

The plugin's config does contain oauth details for the evoluted dev account, however where possible please create a new one using client's account details.

Using EvFacebook Plugin
-----------------------

To include a Facebook stream's posts on a page, load the `EvFacebook.Facebook` helper.

Then from your view, you can retrieve the feed with:

`$this->Facebook->feed($pageId)`

You can optionally override the total number of results using the second param, like so:

`$this->Facebook->feed($pageId, 10)`
