<?php
App::uses('EvFacebookAppModel', 'EvFacebook.Model');
/**
 * EvFacebookFeed Model
 *
 */
class Feed extends EvFacebookAppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'post_id';

	/**
	 * Used to load new posts for a page into the db cache.
	 * @param  integer  $pageId facebook page id
	 * @return void
	 */
	public function loadPosts($pageId = null) {
		$fb = $this->_authenticate();

		if (empty ($pageId)) {
			$pageIds = Configure::read('EvFacebook.pageIds');

			if (! empty($pageIds)) {
				$pageId = $pageIds[0];
			}
		}

		// attempt to retrieve the latest posts from a page
		try {

			$request = $fb->get('/' . $pageId . '/posts/?fields=id,message,story,full_picture,created_time');
			$result = $request->getDecodedBody();

		} catch (Facebook\Exceptions\FacebookResponseException $e) {

			// When Graph returns an error
			CakeLog::write('debug', 'Graph returned an error: ' . $e->getMessage());
			exit;

		} catch (Facebook\Exceptions\FacebookSDKException $e) {

			// When validation fails or other local issues
			CakeLog::write('debug', 'Facebook SDK returned an error: ' . $e->getMessage());
			exit;

		} catch (Exception $e) {

			return false;

		}

		if (! empty($result['data'])) {

			$facebookPosts = array();

			foreach ($result['data'] as $post) {
				$facebookPosts[$post['id']] = $post;
			}

			// Get a list of existing post ids so we can strip them from the array
			$postIds = $this->find('list', [
				'fields' => ['Feed.post_id', 'Feed.id'],
				'conditions' => [
					'Feed.post_id' => array_keys($facebookPosts)
				]
			]);

			if (! empty($postIds)) {
				foreach ($postIds as $postId => $id) {
					unset($facebookPosts[$postId]);
				}
			}

			// Any posts left to insert? If so, do it!
			if (! empty($facebookPosts)) {
				$newPosts = array();

				foreach ($facebookPosts as $postId => $post) {
					$newPosts[] = [
						'page_id' => $pageId,
						'post_id' => $postId,
						'message' => $post['message'],
						'story' => (! empty($post['story']) ? $post['story'] : null),
						'attachment' => (! empty($post['full_picture']) ? $post['full_picture'] : null),
						'post_time' => $post['created_time']
					];
				}

				$this->saveMany($newPosts);
			}

		}
	}

	/**
	 * Used to clear all records for all pages. Generally most sites
	 * will never need more than the standard 25 records, so this should be run
	 * before you retrieve pages if you're using a task or cron job to do so.
	 *
	 * @return bool
	 */
	public function cleanCache() {
		return $this->query('TRUNCATE TABLE ' . $this->tablePrefix . $this->table);
	}

}
