<?php
class EvFacebookAppModel extends AppModel {

	// Prefix with name of plugin to stop conflicts
	public $tablePrefix = "ev_facebook_";

	protected function _authenticate() {
		// Load the facebook app api so we can create a new access token for the main api
		$fbApp = new Facebook\FacebookApp((string)Configure::read('EvFacebook.appId'), Configure::read('EvFacebook.appSecret'), 'v2.7');
		$accessToken = $fbApp->getAccessToken();

		// Load up the main api
		$fb = new Facebook\Facebook([
			'app_id' => (string)Configure::read('EvFacebook.appId'),
			'app_secret' => Configure::read('EvFacebook.appSecret'),
			'default_graph_version' => 'v2.7',
			'default_access_token' => $accessToken
		]);

		return $fb;
	}
}
