<?php

App::uses('AppShell', 'Console/Command');

class UpdateFeedShell extends AppShell {

	public $uses = array('EvFacebook.Feed');

	/**
	 * pulls in new posts from facebook
	 * @return void
	 */
	public function update() {
		$pageIds = Configure::read('EvFacebook.pageIds');

		if (! empty($pageIds)) {

			// Optionaly (and recommended) wipe old posts.
			if (Configure::read('EvFacebook.cleanUp')) {
				$this->Feed->cleanCache();
			}

			foreach ($pageIds as $pageId) {
				$this->Feed->loadPosts($pageId);
			}
		}
	}
}
