EvErrbit
=========
This plugin allows you to integrate with Errbit to log exceptions and errors. 

To use the plugin, simply install with composer and copy the config.php contents to your `app/Config/Plugin/ev_errbit.php` file, updating with your project details.

You can create a project/app inside Errbit. Each project has an id and api key - these will need entering into your `ev_errbit.php` config file.

Once loaded, errors will automatically be handled by Errbit before being passed back to CakePHP.

Manually Logging Exceptions
----------------------------
If you've got a try/catch on your exception and want to log an exception even if the catch is reached (Which you really should), you can manually log items like so:

```
try {
	throw new Exception('test2');
} catch (Exception $e) {
	$handler = new Errbit();
	$handler->handleException($e, true);

	// Place your catch code here
}
```

Notes
=====

* The plugin won't attempt to pass anything to Errbit until you add your Project ID and Project Key.
* After sending to Errbit, the CakePHP error handler is called, so you can still use custom exception renderers.