<?php

$path = dirname(__FILE__);
$pluginDir = explode(DS, dirname($path . '../'));

$pluginName = array_pop($pluginDir);
$pluginConfig = Inflector::underscore($pluginName);
Configure::load($pluginName . '.config');

// Load overrides to settings if they exist
$configOverridePath = APP . 'Config' . DS;
$configOverride = 'Plugin' . DS . $pluginConfig . '.php';

if (file_exists($configOverridePath . $configOverride) && is_readable($configOverridePath . $configOverride)) {

	Configure::load($configOverride);
}

App::uses('Errbit', 'EvErrbit.Lib');

$handler = new Errbit();

Configure::write('Error', array(
	'handler' => 'Errbit::handleError',
	'level' => E_ALL & ~E_DEPRECATED,
	'trace' => true
));
Configure::write('Exception', array(
	'handler' => 'Errbit::handleException',
	'renderer' => 'AppExceptionRenderer',
	'log' => true
));
