<div class="row">
	<div class="col-xs-12 col-sm-9">
		<div itemscope itemtype="http://schema.org/Event" class="ev-event__event">

			<h1 itemprop="name" class="ev-event__event--title"><?php echo $data['Event']['name']; ?></h1>

			<div class="ev-event__event--date" itemprop="startDate" content="<?php echo $this->Time->format('c', $data['Event']['date']); ?>">
				<?php echo $this->Time->format('jS F Y H:i', $data['Event']['date']); ?>
			</div>

			<div itemprop="description" class="ev-event__event--description">
				<?php echo $data['Event']['body']; ?>
			</div>

			<hr>

			<div class="row">
				<div class="col-xs-12">
					<div class="ev-event__event-meta">
						<h3>Event Details</h3>

						<?php

							if (!empty($data['Event']['organiser']) && !empty($data['Event']['organiser_url'])):
							 	$organiser = $this->Html->link($data['Event']['organiser'], $data['Event']['organiser_url']);
							elseif (!empty($data['Event']['organiser'])):
							 	$organiser = $data['Event']['organiser'];
							elseif (!empty($data['Event']['organiser_url'])):
							 	$organiser = $this->Html->link($data['Event']['organiser_url']);
							endif;
						?>

						<?php if (!empty($organiser)): ?>
							<span class="ev-event__event-meta--organiser">
								<strong>Organiser:</strong> <?php echo $organiser; ?>
							</span>
						<?php endif; ?>
					</div>
				</div>

				<?php if (!$data['Event']['hide_address'] && (!empty($data['Event']['postcode']) || !empty($data['Event']['address_line_1']))): ?>
				<div class="col-xs-12 col-sm-6">
					<div class="ev-event__event-address">
						<address>
							<?php
							if (! empty($data['Event']['address_line_1'])):
								echo $data['Event']['address_line_1'].'<br>';
							endif;

							if (! empty($data['Event']['address_line_2'])):
								echo $data['Event']['address_line_2'].'<br>';
							endif;

							if (! empty($data['Event']['address_line_3'])):
								echo $data['Event']['address_line_3'].'<br>';
							endif;

							if (! empty($data['Event']['city'])):
								echo $data['Event']['city'].'<br>';
							endif;

							if (! empty($data['Event']['county'])):
								echo $data['Event']['county'].'<br>';
							endif;

							if (! empty($data['Event']['postcode'])):
								echo $data['Event']['postcode'].'<br>';
							endif;

							if (isset($data['Country']) && ! empty($data['Country'])):
								echo $data['Country']['name'].'<br>';
							endif;
							?>
						</address>
					</div>
				</div>
				<?php endif; ?>

				<?php if (! $data['Event']['hide_map']): ?>
				<div class="col-xs-12 col-sm-6">
					<div class="ev-event__event-map">
						<div class="map" data-lat="<?php echo $data['Event']['map_params']['latitude']; ?>" data-lng="<?php echo $data['Event']['map_params']['longitude']; ?>" data-zoomLevel="14"></div>
					</div>
				</div>
				<?php endif; ?>

			</div>
		</div>
	</div>

	<div class="col-xs-12 col-sm-3">
		<div class="ev-event__sidebar">
			<?php echo $this->Element('EvEvent.sidebar'); ?>
		</div>
	</div>
</div>