<?php

App::uses('EvEventAppModel', 'EvEvent.Model');

class EventCategory extends EvEventAppModel {

	public $hasMany = array(
		'Event' => array(
			'className' => 'EvEvent.Event'
		)
	);

	public $actsAs = array(
		'Routable.Routable' => array(
			'alias' => 'event-category/:displayField',
			'actual' => ':plugin/:controller/view/:primaryKey'
		),
		'MetaData.Meta'
	);

	public $validate = array(
		'name' => array(
			'required' => array(
				'rule' => 'notBlank',
				'message' => 'Required'
			),
			'maxLength' => array(
				'rule' => array('maxLength', 45),
				'message' => 'No more than 45 characters long'
			)
		)
	);

}
