<?php

App::uses('EvEventAppController', 'EvEvent.Controller');

class EventCategoriesController extends EvEventAppController {

	public function beforeFilter() {
		parent::beforeFilter();

		$this->Auth->allow(array(
			'view'
		));

		return;
	}

/**
 * Events category page.
 *
 * @param integer $id
 * @return void
 */
	public function view($id = null) {
		if (empty($id)) {

			$category = array(
				'EventCategory' => array(
					'name' => __('Uncategorised')
				)
			);

			$categoryId = null;

		} else {

			$category = $this->EventCategory->findById($id);
			$categoryId = $id;

			if (empty($category)) {
				throw new NotFoundException();
			}

		}

		$this->Meta->set($category);
		$this->set(compact('category'));

		$params = array(
			'conditions' => array(
				'OR' => array(
					'Event.date >=' => date('Y-m-d'),
					'Event.end_date >=' => date('Y-m-d H:i:s'),
				),
				'Event.event_category_id' => $categoryId
			)
		);
		$this->paginate = array_merge_recursive(
			$this->_processEventListingFilter(),
			$this->_eventListingPaginateDefaults(),
			$params
		);

		$this->set('data', $this->paginate('Event'));

		$this->widgetFutureEvents();
		$this->widgetCategories();

		$this->view = 'EvEvent.view';

		return;
	}

}
