<?php

class EventWidgetsComponent extends Component {

	private $__controller = null;

/**
 * Sets a reference to the calling controller from within the component.
 *
 * @see Component::initialize()
 */
	public function initialize(Controller $controller) {
		parent::initialize($controller);

		$this->__controller = $controller;

		return;
	}

/**
 * Returns an array of months containing events.
 *
 * @param integer $limit maximum number of months to return
 * @return array
 */
	public function futureEvents($limit = 12) {
		$this->Event = ClassRegistry::init('EvEvent.Event');

		$dates = [];
		$time = time();

		$today = date('Y-m-t');

		for ($i = 0; $i < $limit; $i++) {
			$dates[date('Y-m-t', $time)] = date('F Y', $time);
			$time = strtotime('+1 Month', $time);
		}

		// Used to check if a user is logged in so we can remove any private events for guests.
		$user = CakeSession::read("Auth.User");
		$showCount = Configure::read('EvEvent.widget_future_count');

		foreach ($dates as $date => $display) {

			$dateParts = explode('-', $date);
			$dateShort = $dateParts['0'] . '-' . $dateParts['1'];

			$conditions = array(
				'Event.is_active' => 1,
				'Event.date >=' => $dateShort . '-01 00:00:00',
				'Event.date <=' => $date . ' 23:59:59'
			);

			// Check if the user is logged in, and if they aren't remove any events that are
			// restricted to logged in users.
			if (empty($user)) {
				$conditions['Event.logged_in_only'] = 0;
			}

			$count = $this->Event->find('count', array(
				'conditions' => $conditions
			));


			if ($count > 0 && $showCount === true) {
				$dates[$date] .= ' (' . $count . ')';
			} else if ($count === 0) {
				unset($dates[$date]);
			}
		}

		return $dates;
	}

	public function categories($limit = null) {
		$this->Event = ClassRegistry::init('EvEvent.Event');
		$this->EventCategory = ClassRegistry::init('EvEvent.EventCategory');

		$params = array(
			'conditions' => array(
				'EventCategory.is_active' => true
			),
			'order' => array(
				'EventCategory.name' => 'ASC'
			)
		);

		if (!empty($limit)) {
			$params['limit'] = $limit;
		}

		$categories = [0 => __('Uncategorised')];

		$categories += $this->EventCategory->find('list', $params);

		// Used to check if a user is logged in so we can remove any private events for guests.
		$user = CakeSession::read("Auth.User");

		foreach ($categories as $categoryId => &$category) {

			$conditions = array(
				'Event.is_active' => true,
				'Event.event_category_id' => (empty($categoryId) ? null : $categoryId),
				'OR' => array(
					'Event.date >=' => date('Y-m-d H:i:s'),
					'Event.end_date >=' => date('Y-m-d H:i:s'),
				),
			);

			// Check if the user is logged in, and if they aren't remove any events that are
			// restricted to logged in users.
			if (empty($user)) {
				$conditions['Event.logged_in_only'] = 0;
			}

			$count = $this->Event->find('count', array(
				'conditions' => $conditions
			));

			$showCount = Configure::read('EvEvent.widget_category_count');

			if ($count > 0 && $showCount === true) {
				$category .= ' (' . $count . ')';
			} else if ($count === 0) {
				unset($categories[$categoryId]);
			}

		}

		return $categories;
	}

/**
 * Returns an array of events in the future (regardless of how far ahead in the future they are)
 *
 * @param integer $limit maximum number of events to return
 * @return array
 */
	public function getEvents($limit = 5) {
		$this->Event = ClassRegistry::init('EvEvent.Event');

		$conditions = array(
			'Event.is_active' => 1,
			'Event.date >=' => date('Y-m-d H:i:s')
		);

		// Used to check if a user is logged in so we can remove any private events for guests.
		$user = CakeSession::read("Auth.User");

		// Check if the user is logged in, and if they aren't remove any events that are
		// restricted to logged in users.
		if (empty($user)) {
			$conditions['Event.logged_in_only'] = 0;
		}

		$events = $this->Event->find('all', array(
			'conditions' => $conditions,
			'limit' => $limit,
			'order' => 'Event.date ASC',
			'contain' => array(
				'ListingImage',
				'Image'
			)
		));

		return $events;
	}

}