<?php

App::uses('AppController', 'Controller');

class EvEventAppController extends AppController {
	
	public function beforeFilter() {

		parent::beforeFilter();

		$this->EventWidgets = $this->Components->load('EvEvent.EventWidgets');

		return;

	}


/**
 * Process filters for event listing pages. This method modifies 
 * $this->request->data based on set filters and returns parameters for use
 * with paginate.
 * 
 * @return array
 */
	protected function _processEventListingFilter() {

		if (!empty($this->request->data['EventSearch']['sort'])) {

			$this->redirect(array(
				'action' => $this->action,
				'?' => array(
					'data' => array(
						'EventSearch' => array(
							'sort' => $this->request->data['EventSearch']['sort']
						)
					)
				)
			));

			return;

		}

		if (!empty($this->request->query['data'])) {
			$this->request->data = array_merge_recursive($this->request->query['data'], $this->request->data);
		}

		$sort = (!empty($this->request->data['EventSearch']['sort']) && $this->request->data['EventSearch']['sort']==='desc') ? 'DESC' : 'ASC';

		$params = array(
			'order' => 'Event.date ' . $sort
		);

		return $params;

	}


/**
 * Return some shared paginate parameters for event listing pages.
 * 
 * @return array
 */
	protected function _eventListingPaginateDefaults() {

		$params = array(
			'conditions' => array(
				'Event.is_active' => true
			),
			'contain' => array(
				'ListingImage',
				'EventCategory'
			),
			'limit' => 10
		);

		return $params;

	}


/**
 * Sets the categories widget for the views.
 * 
 * @param integer $limit
 * @return void
 */
	public function widgetCategories($limit=null) {

		$categories = $this->EventWidgets->categories($limit);

		$View = new View($this, false);
		$View->set('categories', $categories);
		$output = $View->render('EvEvent.Widgets/categories', false);

		$this->set('ev_event_widget_categories', $output);

		return;

	}


/**
 * Sets the archives widget for the views.
 * 
 * @param integer $limit
 * @return void
 */
	public function widgetFutureEvents($limit=12) {

		$dates = $this->EventWidgets->futureEvents($limit);

		$View = new View($this, false);
		$View->set('dates', $dates);
		$output = $View->render('EvEvent.Widgets/future_events', false);

		$this->set('ev_event_widget_archives', $output);

		return;

	}

}
