<h1 class="title">Export Order Records</h1>

<div class="container-fluid edit-form">
	<div class="row">
		<div class="col-xs-12">
			<div class="panel panel-primary">
				<div class="panel-heading">Select a date range to export orders for.</div>
				<div class="panel-body">
					<?php
					echo $this->Form->create('Order', array(
						'inputDefaults' => array(
							'empty' => '',
							'div' => 'form-group',
							'label' => array(
								'class' => 'col-xs-12 col-sm-2 col-md-3 col-lg-3 control-label'
							),
							'class' => 'form-control',
							'wrapInput' => 'col-xs-12 col-sm-10 col-md-9 col-lg-6',
						),
						'type' => 'file',
						'class' => 'form-horizontal'
					));
					?>
						<p class="alert alert-info">
							It's recommended that you select up to a 1 month period. If you have had a lot of orders, the export will be faster to generate if you pick smaller date periods.
						</p>
					<?php

						echo $this->Form->addField('start_date', array(
							'type' => 'date',
							'required' => true,
							'div' => 'form-group required',
							'default' => date('Y-m-d', strtotime('-1 month'))
						));

						echo $this->Form->addField('end_date', array(
							'type' => 'date',
							'required' => true,
							'div' => 'form-group required',
							'default' => date('Y-m-d')
						));
					?>

					<div class="form-actions">
					    <div class="row">
					        <div class="col-xs-12 col-sm-4 col-sm-offset-2">
					        <?php

					        echo $this->Form->button('<i class="fa fa-cloud-download"></i> Export Orders', array(
					            'div' => false,
					            'type' => 'submit',
					            'class' => 'btn btn-primary submit'
					        ));
					        ?>
					    </div>
					</div>

					<?php
					echo $this->Form->end();
					?>
				</div>
			</div>
		</div>
	</div>
</div>