<?php

class DpdCSVExport {

/**
 * [generateCSV description]
 * @param  array $orders [description]
 * @return string         [description]
 */
	public static function generateCSVArray($orders) {
		// Used headers
		$supportedHeaders = [];

		// Loop through all the orders and get any supported headers they use
		foreach ($orders as $order) {
			$supportedHeaders += array_keys(array_intersect_key($order, self::_getCSVHeaders()));
		}

		// Put them back in the order of _getCSVHeaders
		$supportedHeaders = array_intersect(array_keys(self::_getCSVHeaders()), $supportedHeaders);

		// Now we have the right headers, go through each order and build up the arrays
		$csvDataArray[] = $supportedHeaders;

		foreach ($orders as $order) {
			$csvDataOrderArray = [];
			foreach ($supportedHeaders as $key => $header) {
				if (!empty($order[$header])) {
					$csvDataOrderArray[] = $order[$header];
				} else {
					$csvDataOrderArray[] = '';
				}
			}
			array_push($csvDataArray, $csvDataOrderArray);
		}

		return $csvDataArray;
	}

	protected static function _getCSVHeaders() {
		return array(
			"Shipment Date" => '',
			"Address Line 1" => '',
			"Address Line 3" => '',
			"Postcode" => '',
			"Country Code" => '',
			"Service Code" => '',
			"No. Parcels" => '',
			"Total Weight" => '',
			"Collection on Del." => '',
			"Delivery VAT No." => '',
			"Additional Info" => '',
			"Address Line 2" => '',
			"Address Line 4" => '',
			"Contact Name" => '',
			"Contact Telephone" => '',
			"Customer Ref 1" => '',
			"Customer Ref 2" => '',
			"Customer Ref 3" => '',
			"Content Description" => '',
			"Customs Value" => '',
			"Notification SMS" => '',
			"Notification Email" => '',
			"Organisation" => '',
			"Extended Liability" => '',
			"Extended Liability Val" => '',
			"Return VAT No." => '',
			"Return Additional Info" => '',
			"Return Address Line 1" => '',
			"Return Address Line 2" => '',
			"Return Address Line 3" => '',
			"Return Address Line 4" => '',
			"Return Contact Name" => '',
			"Return Telephone" => '',
			"Return Country Code" => '',
			"Return Customer Ref 1" => '',
			"Return Customer Ref 2" => '',
			"Return Customer Ref 3" => '',
			"Return Description" => '',
			"Return No Parcels" => '',
			"Return Organization" => '',
			"Return Postcode" => '',
			"Return Service Code" => '',
			"Return Total Weight" => '',
			"Shop ID" => '',
			"Shop Postcode" => '',
			"Shop Country Code" => '',
			"Shop Organisation Name" => '',
			"Shop Address Line 1" => '',
			"Shop Address Line 2" => '',
			"Shop Address Line 3" => '',
			"Shop Address Line 4" => '',
			"Shop Compatible" => ''
		);
	}
}
