EvEmail
=======

This plugin provides email templates configurable within the CMS so that an admin has control over the content of their emails. It allows the super user to define the templates and set up required and optional tokens for the email. Also provided is a queue job for running emails that can easily be added to.

Installation
------------

Install using Composer:-

	composer require evoluted/email

Then in `app/Config/bootstrap.php` ensure that you've set your app's fullBaseURL like so:

	Configure::write('App.fullBaseUrl', 'http://www.example.com');

This can of course be set per-environment on console for local testing.

Next run the migrations:-

	cd app && Console/cake Migrations.migration run all --plugin EvEmail

Finally, add a menu item to the templates:-

 * /admin/ev_email/emails

Usage
-----

### Configuring an email template

Only super users can create/delete email templates. Each template has a `name` that is shown to the client and a `system_name` which is used to generate emails in the code. Emails can also be grouped to help organise things for sites that have a large number of templates.

A super user can also define both required and optional tokens that will be replaced by content specified when generating email content. Required tokens must be present in the email `content` for the template to save. This is useful if the email must contain something like a reference code.

Tokens are defined in the admin area using a comma delimited list. For example:-

	firstName, lastName, bookingRef

To use tokens in the content, wrap the token name in curly brackets:-

	{firstName}

If you need to insert a token that will be replaced by block content, for example a table, and you want any wrapping paragraph tags inserted by the WYSIWYG editor removed you can wrap the token name in double equals (*i.e.* `==`):-

	{==bookingDetails==}

To pass the form validation, make sure the required/optional token field also contains the double equals. For example:-

    firstName, lastName, ==bookingDetails==

Email templates have optional from name and email address fields. These can be used to configure the email to be sent from an address different to the site's admin email configured in the site settings.

### Styling user generated content

To ensure all markup is styled correctly in the email, for example headings and links, include the CSS in a style block in the email template. For example:-

	<style type="text/css">
		a {
			color: red;
			text-decoration: text-underline;
		}
	</style>

EvEmail uses the `InlineCSS` plugin that will apply the defined styles to the elements so that they will style correctly when rendered in the recipients email app. You can even use class names as you normally would!

#### Gmail Padding Issues

If Gmail (or another email viewer) is causing issues by adding extra padding or HTML elements to the email it could be due to whitespace. By enabling the `strip_content_whitespace` flag in the config, the whitespace between tags will be removed. This seems to help Gmail render tables properly.

### Sending an email

To send an email you will first need to generate the email data using `generateEmailData()`:-

	$EvEmail = ClassRegistry::init('EvEmail.Email');
	$email = $EvEmail->generateEmailData(
		// Either pass the integer ID of the template or the template's `system_name`
		'some_system_name',
		[
			// Your token replacements
			'firstName' => 'Joe',
			'lastName' => 'Bloggs'
		]
	);

This returns an array of email data that you can use to send the email. It will contain the email's content with all the tokens replaced (`$email['Email']['content']`). If the email template has been disabled (*i.e.* `is_active = false`) then this method will return `false`.

If you want to use the `Queue` plugin for sending email (which is advisable) this plugin has a handy method for adding emails to the queue, `addToQueue()`, called like this:-


	$EvEmail->addToQueue(
		$email['Email']['subject'],
		$email['Email']['content'],
		['joe@example.com' => 'Joe Bloggs'],
		[
			'from' => [
				'evoluted@evoluted.net' => 'Evoluted New Media',
			],
			'template' => 'name_of_email_template_ctp',
			'cc' => 'cc@evoluted.net',
			'bcc' => 'bcc@evoluted.net',
			'replyTo' => 'replyTo@evoluted.net',
			'helpers' => ['Time', 'Html'],
			'headContent' => {some_additional_script},
			'layout' => some_layout,
			'attachments' => ['photo.png' => '/full/some_hash.png'],
			'viewVars' => [
				'emailTitle' => 'Evoluted Weekly Summary Email',
				'subtitle' => 'Some subtitle',
				'{some_key}' => '{some_content}'
			]
		]
	);

You can use this method to send any email via the queue, not just an email generated using the plugin.

To add content to the head such as extra styles or scripts (beware scripts will not be run in emails but some sites like Trustpilot use it for storing properties), use the `$headContent` parameter. This will pass the `$headContent` variable through to your layout so it can be rendered in the head.
You can also use an alternative layout by setting the `$layout` parameter.

Attachments are to be provided in the same style as standard [CakePhp email attachments](https://book.cakephp.org/2.0/en/core-utility-libraries/email.html#sending-attachments).

To pass the `notBefore`, `group` and `reference` fields through to the queued task, add them as part of the additionalParams array prefixed with "queue", for example the `notBefore` field should be passed as `queueNotBefore`. The fields are removed from the additionalParams after they have been used. The queued task fields are only available through the use of the `addToQueue()` method and not the `queueEmail()` method.

Development
-----------

When developing EvEmail please make sure that the unit tests run successfully and add tests for any new features you add. If you find a bug and fix it add a test case to ensure that the bug is resolved and doesn't get broken again.

You can either run the tests from the browser:-

	/test.php?case=AllEvEmail&plugin=EvEmail

Or from the command line:-

	cd app && Console/cake test EvEmail AllEvEmail

If you don't know how unit testing works in CakePHP ask!
