<?php

class EmailTest extends CakeTestCase {

	public $fixtures = [
		'plugin.ev_email.Email',
	];

	public function setUp() {
		parent::setUp();
		$this->Email = ClassRegistry::init('EvEmail.Email');
	}

	public function testGenerateEmailDataWithTokens() {
		$result = $this->Email->generateEmailData(1, ['full_name' => 'Joe Bloggs', 'site_name' => 'Example']);
		$this->assertEquals('Foo bar', $result['Email']['subject']);
		$this->assertEquals('<p>Hi Joe Bloggs,</p><p>Regards<br />Example</p>', $result['Email']['content']);

		$result = $this->Email->generateEmailData(1, ['full_name' => null, 'site_name' => 'Example']);
		$this->assertEquals('Foo bar', $result['Email']['subject']);
		$this->assertEquals('<p>Hi ,</p><p>Regards<br />Example</p>', $result['Email']['content']);

		$result = $this->Email->generateEmailData(4, ['ref' => 'foo']);
		$this->assertEquals('Booking foo', $result['Email']['subject']);

		return;
	}

	public function testGenerateEmailDataNoTokens() {
		$result = $this->Email->generateEmailData(2, []);
		$this->assertEquals('Hello', $result['Email']['subject']);
		$this->assertEquals('<p>Hello world</p>', $result['Email']['content']);

		return;
	}

	public function testGenerateEmailDataWithAdvancedTokens() {
		$result = $this->Email->generateEmailData(3, ['name' => 'Joe Bloggs', 'block' => '<div>Goodbye</div>']);
		$this->assertEquals('Hello (again)', $result['Email']['subject']);
		$this->assertEquals('<p>Hello Joe Bloggs</p><div>Goodbye</div>', $result['Email']['content']);

		return;
	}

	public function testGenerateEmailDataForDisabledTemplate() {
		$result = $this->Email->generateEmailData(5, []);
		$this->assertFalse($result);

		return;
	}

	public function testValidation() {
		$result = $this->Email->save(['id' => 1, 'content' => '<p>Hi {full_name},</p><p>Best regards<br />{site_name}</p>']);
		$this->assertTrue($result !== false);

		return;
	}

/**
 * Test that validation passes when there are no required tokens for the template being saved (this
 * has been a bug in the past).
 *
 * @return void
 */
	public function testValidationNoRequiredTokens() {
		$result = $this->Email->save(['id' => 2, 'content' => '<p>Hi {full_name},</p><p>Best regards<br />{site_name}</p>']);
		$this->assertTrue($result !== false);

		return;
	}

	public function testValidationFails() {
		$result = $this->Email->save(['id' => 1, 'content' => '<p>Hi,</p><p>Regards<br />{site_name}</p>']);
		$this->assertFalse($result);

		return;
	}

/**
 * Test email list is split into an array correctly
 *
 * @return void
 */
	public function testSplitEmails() {
		$result = $this->Email->splitEmails('andy@evoluted.net, ash@evoluted.net');
		$this->assertCount(2, $result);

		return;
	}

/**
 * Test email list validation passes for valid email addresses
 *
 * @return void
 */
	public function testValidateEmailList() {
		$result = $this->Email->validateEmailList((array)'andy@evoluted.net, ash@evoluted.net');
		$this->assertTrue($result);

		return;
	}

/**
 * Test email list validation fails for non-email addresses
 *
 * @return void
 */
	public function testValidateEmailListFails() {
		$result = $this->Email->validateEmailList((array)'andy@evoluted.net, foo, ash@evoluted.net');
		$this->assertFalse($result);

		return;
	}

}
