<?php

App::uses('QueueTask', 'Queue.Console/Command/Task');
App::uses('CustomEmail', 'Lib');
App::uses('Email', 'EvEmail.Email');

class QueueEvEmailTask extends QueueTask {

/**
 * Run task - send email
 *
 * @param array $data
 * @param int $id
 * @return bool
 */
	public function run($data, $id = null) {
		$Email = new CustomEmail();

		// We want to send the email in both HTML and plain text format (apparently this helps stop
		// the email from being flagged as spam).
		$Email->emailFormat('both');

		// Setup the email template.
		$template = !empty($data['template']) ? $data['template'] : 'default';
		$layout = !empty($data['layout']) ? $data['layout'] : 'default';

		// Make sure the base URL gets set.
		Router::fullBaseUrl($data['domain']);
		$Email->domain($data['domain']);

		$Email->template($template, $layout);

		$Email->to($data['to']);
		if (!empty($data['cc'])) {
			$Email->cc($data['cc']);
		}
		if (!empty($data['bcc'])) {
			$Email->bcc($data['bcc']);
		}
		if (!empty($data['replyTo'])) {
			$Email->replyTo($data['replyTo']);
		}
		if (!empty($data['attachments'])) {
			$Email->attachments($data['attachments']);
		}

		$Email->from($data['from']);
		$Email->subject($data['subject']);

		$viewVars = [
			'content' => $data['content'],
			'headContent' => $data['headContent'],
			// Generate a plain text version of the email
			'text' => ClassRegistry::init('EvEmail.Email')->textContent($data['content']),
		];

		// If any additional view vars have been passed through, merge the arrays
		if (!empty($data['viewVars'])) {
			$viewVars = array_merge_recursive($viewVars, $data['viewVars']);
		}

		// Set view vars
		$Email->viewVars($viewVars);

		$helpers = ['InlineCss.InlineCss'];
		if (!empty($data['helpers'])) {
			$helpers = array_merge($helpers, $data['helpers']);
		}
		// Inline the CSS.
		$Email->helpers($helpers);

		return $Email->send();
	}

}
