# EvDownloads

CakePHP plugin for `EvCore` for adding a downloads section to an app

## Installation

Begin by installing the plugin through `Composer`. From the projects root directory execute to following command

	composer require evoluted/downloads

Run the database migrations from the projects `app` directory

	Console/cake Migrations.migration run all -p EvDownloads

If a `CakePlugin::loadAll();` call is _not_ present in your projects `bootstrap.php` then load `EvDownloads` from the `bootstrap.php` project file using the following command

	CakePlugin::load('EvDownloads', ['bootstrap' => true, 'config' => true]);

Lastly, add access to the to through the admin by adding it to the admin menu using the following URL

 	/admin/ev_downloads/downloads

## Usage

Add the plugins `Component` to the `Controller` used to load the template. For example, if the downloads listing is required on a Downloads page then update `EvCorePagesController.php` with the following

	public $components = [
		...
		'EvDownloads.Downloads'
	];

Or within the `__constuct` method to assign on the fly

	if (CakePlugin::loaded('EvDownloads')) {
		$this->components[] = 'EvDownloads.Downloads';
	}

The required downloads listing can be retrieved from the plugin `Component` from any view action method or from the `TemplateUtil`, shown in the following example. The downloads array data will then be available to use with the view template.

	$this->set(
		'downloads',
		$this->Downloads->getDownloads()
	);

You can pass an array of standard query parameters in to the getDownloads function.

### Download Categories

There is a basic Category system implemented within the Downloads plugin. It utilises a HABTM relationship to link Downloads to Download Categories. You will be able to pass the necessary contains/joins/conditions in to the `getDownloads` call to get the results required.

To enable the category system, set the `enableCategories` configuration option to `true`.

## Extras

### Limiting file extensions

The `config.php` can be used to specify what file extensions are supported through the plugin. If you haven't already extend the config file by copying it to your `app/Config/` directory and rename it to `ev_downloads.php`. An array of supported file extensions can be added to the configuration file, the plugin will validate against these when new files are added through the admin

	// contents of an example extended ev_downloads.php file using supported file extensions

	'EvDownloads' => [
		...
		'supportedFileExtensions' => [
			'doc',
			'docx',
			'pdf',
			'xls',
			'xlsx'
		]
	];

Omitting the `supportedFileExtensions` array will allow all file extensions to be saved.

## Feature Suggestions

* Include an example view template
