<?php

App::uses('EvDownloadsAppModel', 'EvDownloads.Model');

/**
 * Download Category Model
 *
 */
class DownloadCategory extends EvDownloadsAppModel {

	public $hasAndBelongsToMany = array(
		'Download' => array(
			'className' => 'EvDownloads.Download',
			'joinTable' => 'ev_downloads_download_categories_downloads'
		)
	);

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = [
		'name' => [
			'notEmpty' => [
				'rule' => ['notBlank'],
				'message' => 'Please enter a name'
			]
		]
	];

/**
 * Returns results of the find query based on the the supplied parameters
 *
 * @param array $additionalParams The supplied find query params
 * @return array Contains the result of the find query
 */
	public function readForList(array $additionalParams = []) {
		$defaultParams = [
			'conditions' => [
				$this->alias . '.is_active' => true
			],
			'contain' => [
				'Download'
			]
		];

		$params = array_merge_recursive($defaultParams, $additionalParams);

		return $this->find('all', $params);
	}

}
