<?php

App::uses('EvDownloadsAppModel', 'EvDownloads.Model');

/**
 * Download Model
 *
 */
class Download extends EvDownloadsAppModel {

	public $documentSlots = 1;

	public $hasAndBelongsToMany = array(
		'DownloadCategory' => array(
			'className' => 'EvDownloads.DownloadCategory',
			'joinTable' => 'ev_downloads_download_categories_downloads'
		)
	);

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = [
		'name' => [
			'notEmpty' => [
				'rule' => ['notBlank'],
				'message' => 'Please enter a name'
			]
		]
	];

/**
 * beforeValidate Callback
 *
 * @param array $options Options passed from Model::save().
 * @return bool
 * @see Model::save()
 */
	public function beforeValidate($options = array()) {
		// add file type extension validation rules, if suppplied in the plugin config
		if (Configure::check('EvDownloads.supportedFileExtensions')) {
			$supportedFileExtensions = Configure::read('EvDownloads.supportedFileExtensions');

			$fileExtensionValidation = [
				'filename' => [
					'rule' => ['isValidExtension', $supportedFileExtensions, false],
					'message' => 'The document file type extension is not supported. Please upload one of the following file type extensions ' . implode($supportedFileExtensions, ', ')
				]
			];

			$this->Document->validate = array_merge_recursive(
				$this->Document->validate,
				$fileExtensionValidation
			);
		}

		return parent::beforeValidate($options);
	}

/**
 * Returns results of the find query based on the the supplied parameters
 *
 * @param array $additionalParams The supplied find query params
 * @return array Contains the result of the find query
 */
	public function readForList(array $additionalParams = []) {
		$defaultParams = [
			'conditions' => [
				$this->alias . '.is_active' => true
			],
			'contain' => [
				'Document'
			]
		];

		$params = array_merge_recursive($defaultParams, $additionalParams);

		return $this->find('all', $params);
	}

	/**
	 * Query used to retrieve a record ready for edit
	 *
	 * @param integer $id ID of row to edit
	 * @param array $params The db query array - can be used to pass in additional parameters such as contain
	 * @return array
	 */
	public function readForEdit($id, $params = array()) {
		$params['contain'][] = 'DownloadCategory';

		$data = parent::readForEdit($id, $params);

		return $data;
	}
}
