<?php

App::uses('EvDownloadsAppController', 'EvDownloads.Controller');

/**
 * Downloads Controller
 *
 * @property Downloads $Downloads
 */
class DownloadsController extends EvDownloadsAppController {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'name';

	/**
	 * Used to populate form drop down selects
	 */
	protected function _adminPopulateLookups() {
		parent::_adminPopulateLookups();

		if (Configure::read('EvDownloads.enableCategories') === true) {
			$this->loadModel('EvDownload.DownloadCategory');
			$downloadCategories = $this->DownloadCategory->find('list', array(
				'order' => 'DownloadCategory.name ASC'
			));
			$this->set('downloadCategories', $downloadCategories);
		}
	}

	/**
	 * Defines the fields displayed in a filter form.
	 *
	 * Defaults to id, display name, is_active, created and modified fields.
	 *
	 * Override in your controller to customise.
	 *
	 * Format:
	 *
	 * 'id' => array(
	 *         'label' => label text,
	 *         'type' => data type of control
	 *         'compare' => SQL query. e.g. Model.field='%s' (where %s is replace by the value of the field)
	 *         'default' => value you want the data filtering by by default
	 * )
	 */
	protected function _adminFilterFields() {
		$filters = parent::_adminFilterFields();

		if (Configure::read('EvDownloads.enableCategories') === true) {
			$additionalFilters = array(
				'DownloadDownloadCategory.download_category_id' => array(
					'type' => 'select',
					'label' => 'Category',
					'compare' => array(
						'DownloadDownloadCategory.download_category_id' => '%s'
					)
				)
			);

			$Model = $this->{$this->modelClass};
			$filters = ArrayUtil::addAfter($filters, $Model->alias . '.name', $additionalFilters);
		}

		return $filters;
	}

	/**
	 * Pagination settings for admin_index
	 *
	 * @return array
	 */
	protected function _adminIndexPaginate() {
		$query = parent::_adminIndexPaginate();

		if (Configure::read('EvDownloads.enableCategories') === true) {
			$query['joins'][] = array(
				'table' => 'ev_downloads_download_categories_downloads',
				'alias' => 'DownloadDownloadCategory',
				'conditions' => 'Download.id = DownloadDownloadCategory.download_id',
				'type' => 'left'
			);

			$query['group'] = 'Download.id';
		}

		return $query;
	}

	/**
	 * Defines the fields displayed in an admin_form for this model
	 *
	 * Defaults to all fields in the db table
	 */
	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();
		$Model = $this->{$this->modelClass};

		if (Configure::read('EvDownloads.showDownloadUrls')) {
			if (!empty($this->request->data['Document'][0]['uuid'])) {

				$urlParams = [
					'admin' => false,
					'plugin' => 'ev_core',
					'controller' => 'documents',
					'action' => 'download',
					$this->request->data['Document'][0]['uuid']
				];

				$fields = ArrayUtil::addAfter($fields, $Model->alias . '.name', [
					$Model->alias . '.internal_url' => [
						'type' => 'string',
						'readonly' => 'readonly',
						'value' => Router::url( $urlParams ),
						'displayInfo' => 'Use the above when creating a link on a page on this website.'
					],
					$Model->alias . '.external_url' => [
						'type' => 'string',
						'readonly' => 'readonly',
						'value' => Router::url( $urlParams, true ),
						'displayInfo' => 'Use the above when sharing the link on other websites and social media.'
					]
				]);
			}
		}

		if (Configure::read('EvDownloads.enableCategories') === true) {
			// Add download category multicheck field
			$additionalFields['DownloadCategory'] = array(
				'type' => 'multicheck',
				'label' => 'Category'
			);
			$fields = ArrayUtil::addAfter($fields, $Model->alias . '.content', $additionalFields);
		}

		return $fields;
	}

/**
 * Manages an admin edit form for this model
 *
 * @param int $id ID of row to edit
 * @return void
 */
	public function admin_edit($id = null) {
		parent::admin_edit($id);

		// if validation errors are returned from the Document model it is
		// safe to presume that we can discard the failed document file
		if (
			! empty($this->{$this->modelClass}->validationErrors['Document']) &&
			! empty($this->request->data['Document'])
		) {
			$this->request->data['Document'] = [];
		}
	}

}
