<?php

App::uses('EvDownloadsAppModel', 'EvDownloads.Model');

/**
 * Download Model
 *
 */
class Download extends EvDownloadsAppModel {

	public $documentSlots = 1;

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = [
		'name' => [
			'notEmpty' => [
				'rule' => ['notBlank'],
				'message' => 'Please enter a name'
			]
		]
	];

/**
 * beforeValidate Callback
 *
 * @param array $options Options passed from Model::save().
 * @return bool
 * @see Model::save()
 */
	public function beforeValidate($options = array()) {
		// add file type extension validation rules, if suppplied in the plugin config
		if (! empty(Configure::read('EvDownloads.supportedFileExtensions'))) {
			$supportedFileExtensions = Configure::read('EvDownloads.supportedFileExtensions');

			$fileExtensionValidation = [
				'filename' => [
					'rule' => ['isValidExtension', $supportedFileExtensions, false],
					'message' => 'The document file type extension is not supported. Please upload one of the following file type extensions ' . implode($supportedFileExtensions, ', ')
				]
			];

			$this->Document->validate = array_merge_recursive(
				$this->Document->validate,
				$fileExtensionValidation
			);
		}

		return parent::beforeValidate($options);
	}

/**
 * Returns results of the find query based on the the supplied parameters
 *
 * @param array $additionalParams The supplied find query params
 * @return array Contains the result of the find query
 */
	public function readForList(array $additionalParams = []) {
		$defaultParams = [
			'conditions' => [
				$this->alias . '.is_active' => true
			],
			'contain' => [
				'Document'
			]
		];

		$params = array_merge_recursive($defaultParams, $additionalParams);

		return $this->find('all', $params);
	}

}
