<?php

App::uses('EvDownloadsAppController', 'EvDownloads.Controller');

/**
 * Downloads Controller
 *
 * @property Downloads $Downloads
 */
class DownloadsController extends EvDownloadsAppController {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'name';

/**
 * Manages an admin edit form for this model
 *
 * @param int $id ID of row to edit
 * @return void
 */
	public function admin_edit($id = null) {
		parent::admin_edit($id);

		// if validation errors are returned from the Document model it is
		// safe to presume that we can discard the failed document file
		if (
			! empty($this->{$this->modelClass}->validationErrors['Document']) &&
			! empty($this->request->data['Document'])
		) {
			$this->request->data['Document'] = [];
		}
	}

}
