# EvDiscount

## Installation

Simply add EvDiscount to the `install.php` file within the Config directory and run `Console/cake installer core` once you have added all the other plugins you will need.

If this has already been run, simply run `Console/cake installer plugin EvDiscount`.

The installer will automatically setup the database tables and create a link within the admin menu to create discount codes.

## How it works

The discount plugin currently works based on the events system to trigger when a valid discount code has been added. If using within a standard E-Commerce setup everything is already in place, however if used outside of this some setup work will be needed.

Discount codes can be created at a fixed rate or a percentage amount, restrictions on the number of redemptions is currently **not implemented**, it was planned that this would use `EvInventory` functionality to manage this but never got round to it.

The cookie is stored against the basket in the `ev_basket_basket_data` table under the name `discount_code`. It is added by the basket plugin to this table when the event `EvDiscount.Component.DiscountCodes.codeAdded` is fired.

The contents of basket_data are transferred to the order so a record of the discount code is kept.

Upon `EvCheckout.Controller.Order.success` the discount code uses is incremented.

To do the discount calculations it uses the PriceModifier library https://github.com/EvolutedNewMedia/pricemodifier

## Setup

Once installer has run, simply log into the admin to create any discount codes needed for the site.

Then within the templates, echo out the element that is bundled with `EvDiscount` to add a discount add form to the page.

	<?=$this->element('EvDiscount.Discounts/form')?>

If using outside of the standard EvCommerce setup, you will then need to create an Event listener to listen for `EvDiscount.Component.DiscountCodes.codeAdded`. This event is triggered when a valid code is added, within this listener you should then apply the discount code to your items.

Within `EvBasket` is the listener for the basket plugin that applies the discount code to a customers basket so this can be used as a rough guide.


If used in a custom scenario, you will also need to make sure any discount cookies are cleared upon checkout or purchase of the discounted items.

### Multi-Currency Support
As of version 2.3.2.0, EvDiscount uses multi-currency support as standard. This will pull in EvCurrency which is needed to store/manage currency records.

Each discount code can be assigned to a currency code, and will only work for that one currency code.

## Events

### EvDiscount.Component.DiscountCodes.codeAdded

When a discount code has been successfully validated, this event is triggered. Your code will need to listen for this event and then apply as needed.

EvBasket comes with this listener built in if EvDiscount is detected, this listener will take the code and check any code restrictions are met (correct protects are in the basket) and that the min order is met.

#### Parameters

* `code` - The actual code used
* `data` - Full data array of the code and code restrictions

## Restrictions
Restrictions can be given to discount codes through the admin using the "Code Restrictions" tab. By default this tab won't appear until you have added the models you want to restrict by to the config. For example:

	'restrictTo' => array(
		'EvShop.Product'
	),

Any products then selected on the discount code's restrictions will be able to receive that discount.

If you are using the standard EvCommerce setip then checking discount restrictions for Products, Brands and Categories are already set up. For anything else restrictions will need to be set.

### Free Delivery Restrictions
As of version `2.5.2.4` you can restrict Free Delivery discounts to specific delivery methods (i.e. UK Express) by adding the following to your `restrictTo` config:

	'ShippingRule' => 'EvShipping.ShippingRule'

In order for this to work you will need EvShipping `2.2.4.2` and EvBasket `2.2.21.4` or above.

## Discount Types
Discount types can be added by adding a new discount modifier to the libs folder and an entry to match in the database. if using EvBasket, you will need to add the new discount type to the discount event listener. The amount field can be given a custom label or hidden via the `'amountField'` section in the config file. As of version 2.5.2.0 the discount types are as follows:

### Fixed
Reduces the basket by a fixed amount.

### Percentage
Reduces the basket by a percentage amount.

### Buy X get cheapest free
For every X (amount) of items, the cheapest will be discounted from the basket.

### Buy X get cheapest half price
Same as the above but half the price of the cheapest item is deducted.

### Free Gift
One type of item will be free when bought with any other qualifying item. The price modifier does not add the free item into the basket if it's not there but EvBasket has been updated separately to allow this.

### X for the price of Y
For every X (amount) items, the price of X (amount) - Y (quantity_to_pay_for) will be deducted from the basket. The cheapest will be discounted first.

### Free delivery
This grants free delivery with at least one qualifying item.

### X for the fixed price of Y
For every X (amount) items, the price of Y (fixed_price) will be charged. The cheapest will be discounted first. E.g. Buy Two for £10.


