<?php
	echo $this->Form->addField(
		'CodeRestriction.' . $restriction['label'] . '.model',
		[
			'type' => 'hidden',
			'value' => $restriction['model']
		]
	);

	// Turn the current code restrictions into values so they appear as pre selected
	$this->request->data['CodeRestriction'][$restriction['label']]['model_id'] = Hash::extract($currentRestrictions, '{n}[model=' . $restriction['model'] . '].model_id');

	echo $this->Form->addField(
		'CodeRestriction.' . $restriction['label'] . '.current_model_id',
		[
			'type' => 'hidden',
			'value' => json_encode(Hash::combine($currentRestrictions, '{n}[model=' . $restriction['model'] . '].id' ,'{n}[model=' . $restriction['model'] . '].model_id'))
		]
	);

	echo $this->Form->addField(
		'CodeRestriction.' . $restriction['label'] . '.model_id',
		[
			'label' => Inflector::pluralize($restriction['label']),
			'data-placeholder' => 'Select ' . $restriction['label'] . ' Restrictions',
			'type' => 'chosen_multiselect',
			'options' => $restriction['data'],
		]
	);
