<?php
namespace Evoluted\PriceModifier\DiscountModifiers;

use Evoluted\PriceModifier\Interfaces\DiscountModifierInterface;
use Evoluted\PriceModifier\DiscountModifiers\FixedDiscountModifier;

/**
 * A fixed discount handler for the PriceModifer package.
 *
 * @package 	PriceModifier
 * @author 		Rick Mills <rick@evoluted.net>
 * @author 		Sam Biggins <sam@evoluted.net>
 * @author		Evoluted New Media <developers@evoluted.net>
 * @license     http://mit-license.org/
 *
 * @link		https://github.com/evolutednewmedia/pricemodifier
 *
 */
class VoucherDiscountModifier extends FixedDiscountModifier implements DiscountModifierInterface
{
	/**
	 * Applies the discount to the loaded basket.
	 *
	 * @return BasketInterface Returns the modified basket
	 */
	public function applyDiscount()
	{
		if ($this->params['applyToItems']) {
			foreach ($this->basket->items() as $basketItem) {
				if ($this->basket->validDiscount($this->id, $basketItem)) {
					$this->_applyDiscount($basketItem->taxRate());
				}

			}
		} else {
			$this->_applyDiscount($this->basket->getBasketTaxRate());
		}

		return $this->basket;
	}
}
