<?php
namespace Evoluted\PriceModifier\DiscountModifiers;

use Evoluted\PriceModifier\DiscountModifiers\BaseDiscountModifier;
use Evoluted\PriceModifier\Interfaces\DiscountModifierInterface;

/**
 * A discount handler for the PriceModifer package. The price of a free gift is discounted from the basket.
 *
 * @package 	PriceModifier
 * @author		Evoluted New Media <developers@evoluted.net>
 * @license     http://mit-license.org/
 *
 * @link		https://github.com/evolutednewmedia/pricemodifier
 *
 */
class FreeGiftDiscountModifier extends BaseDiscountModifier implements DiscountModifierInterface {

/**
 * Applies the discount to the loaded basket.
 *
 * @return BasketInterface Returns the modified basket
 */
	public function applyDiscount() {
		//
		$freeProductIds = $this->params['extra_data']['free_gift_product_id'];
		$freeItems = [];
		$totalFreeItems = 0;
		$totalCount = 0;

		foreach ($this->basket->items() as $basketItem) {
			if (in_array($basketItem->Variant['product_id'], $freeProductIds)) {
				$freeItems[] = $basketItem;
				$totalFreeItems += $basketItem->quantity;
			} elseif ($this->basket->validDiscount($this->id, $basketItem)) {
				$totalCount += $basketItem->quantity;
			}
		}

		$amount = (!empty((int)$this->params['amount'])) ? $this->params['amount'] : 1;
		$numToDiscount = ($totalCount < $amount) ? $totalCount : $amount;
		if ($numToDiscount > 0) {

			// Give the cheapest away free first
			usort($freeItems, function ($a, $b) {
				if ($a->unitPrice > $b->unitPrice) {
					return 1;
				} elseif ($a->unitPrice < $b->unitPrice) {
					return -1;
				} else {
					return 0;
				}
			});

			foreach ($freeItems as $item) {
				if ($item->quantity < $numToDiscount) {
					extract($this->_normaliseDiscount($item->unitPrice * $item->quantity, $item->unitPrice * $item->quantity * ($item->taxRate() / 100)));
					$numToDiscount -= $item->quantity;
				} else {
					extract($this->_normaliseDiscount($item->unitPrice * $numToDiscount, $item->unitPrice * $numToDiscount * ($item->taxRate() / 100)));
					$numToDiscount = 0;
				}

				if (!isset($this->basket->discountBreakdown[$this->id]['amount'])) {
					$this->basket->discountBreakdown[$this->id]['amount'] = 0;
				}
				if (!isset($this->basket->discountBreakdown[$this->id]['tax'])) {
					$this->basket->discountBreakdown[$this->id]['tax'] = 0;
				}

				$this->basket->discountBreakdown[$this->id]['amount'] += $discountSubtotal;
				$this->basket->discountBreakdown[$this->id]['tax'] += $discountTax;

				if ($numToDiscount <= 0) {
					// Nothing else to do
					break;
				}
			}
		}

		return $this->basket;
	}
}
