<?php
namespace Evoluted\PriceModifier\DiscountModifiers;

use Evoluted\PriceModifier\DiscountModifiers\BaseDiscountModifier;
use Evoluted\PriceModifier\Interfaces\DiscountModifierInterface;

/**
 * A discount handler for the PriceModifer package. Discount the delivery price from the basket total. Delivery price must be passed in the extra params.
 *
 * @package 	PriceModifier
 * @author		Evoluted New Media <developers@evoluted.net>
 * @license     http://mit-license.org/
 *
 * @link		https://github.com/evolutednewmedia/pricemodifier
 *
 */
class FreeDeliveryDiscountModifier extends BaseDiscountModifier implements DiscountModifierInterface {

	/**
	 * Applies the discount to the loaded basket.
	 *
	 * @return BasketInterface Returns the modified basket
	 */
	public function applyDiscount() {
		//
		$delivery = $this->params['delivery'];
		$deliveryTax = $this->params['deliveryTax'];

		$isValid = false;

		foreach ($this->basket->items() as $basketItem) {
			if ($basketItem->quantity > 0 && $this->basket->validDiscount($this->id, $basketItem)) {
				$isValid = true;
				break;
			}
		}

		// We have a valid item
		if ($isValid) {

			if ($delivery > 0) {
				$this->basket->discountBreakdown[$this->id]['amount'] = $delivery;
				$this->basket->discountBreakdown[$this->id]['tax'] = $deliveryTax;
			} else {
				// Add this to the discount breakdown so it is recorded and can be applied later.
				// otherwise it will be ignored and not applied at checkout.
				$this->basket->discountBreakdown[$this->id]['amount'] = 0;
				$this->basket->discountBreakdown[$this->id]['tax'] = 0;
			}

		}

		return $this->basket;
	}
}
