<?php

App::uses('CakeEventListener', 'Event');

class EvDiscountEditOrderListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'EvCheckout.EditOrder.currentlyEditing' => 'onEditingOrder'
		);
	}

	/**
	 * Allows disabled discounts when editing an order
	 *
	 * @param CakeEvent
	 */
	public function onEditingOrder(CakeEvent $Event) {
		// Allow discounts to be applied after they have expired if editing an order
		$Discount = EvClassRegistry::init('EvDiscount.DiscountCode');
		$Discount->allowDisabledCodes = true;

		return true;
	}

}
