<?php

App::uses('CakeEventListener', 'Event');

class EvDiscountDiscountListener implements CakeEventListener {

	public function implementedEvents() {
		return array(
			'EvCheckout.Controller.Order.success' => 'incrementDiscountCounter'
		);
	}

	/**
	 * Increments the discount code usage
	 *
	 * @param 	CakeEvent
	 */
	public function incrementDiscountCounter(CakeEvent $Event) {
		// Retrieve discount code details from the basket data
		$Discount = EvClassRegistry::init('EvDiscount.DiscountCode');
		$OrderData = EvClassRegistry::init('EvCheckout.OrderData');

		$orderId = $Event->data['orderId'];

		// Get the order data to see if there is any discount code present
		$discountCodes = $OrderData->find('list', array(
			'fields' => array(
				'id',
				'data'
			),
			'conditions' => array(
				$OrderData->alias . '.order_id' => $orderId,
				$OrderData->alias . '.name' => array('discount_code', 'voucher_code')
			)
		));

		// Loop through all the discount codes applied to the order and increment each one
		foreach ($discountCodes as $discountCode) {
			//Find the discount code in the database by name
			$Discount->increaseTimesUsedByCode($discountCode);
		}

		return true;
	}

}
