<?php

class DiscountLib {

	/**
	 * calculate the discount amount
	 *
	 * @param 	array 	$codeData 	The code data we are calculating
	 * @param 	float 	$subtotal 	The subtotal amount to calculate percentages off
	 * @return 	float 	$amount 	The discount amount
	 */
	public static function calculate($codeData, $subtotal) {
		if (empty($codeData['DiscountCode']['amount']) || $codeData['DiscountCode']['amount'] == '0.000000') {
			return 0;
		}

		$amount = 0;
		if ($codeData['DiscountCode']['discount_type_id'] == 1) {
			//Just return the amount if it is fixed
			$amount = $codeData['DiscountCode']['amount'];
		} elseif ($codeData['DiscountCode']['discount_type_id'] == 2) {
			//Work out the percentage
			$amount = ($codeData['DiscountCode']['amount'] / 100) * $subtotal;

			//Check the percentage wasn't larger than 100%, if so return subtotal;
			if ($amount > $subtotal) {
				$amount = $subtotal;
			}
		}

		return $amount;
	}
}
