<?php

App::uses('DiscountCodesController', 'EvDiscount.Controller');
App::uses('ArrayUtil', 'EvCore.Lib');

class VoucherCodesController extends DiscountCodesController {

	public $uses = 'EvDiscount.VoucherCode';

	/**
	 * Paginator filter by vouchers only
	 *
	 * @var array
	 */
	public $adminPaginate = array(
		'contain' => array(
			'Currency'
		),
		'conditions' => array(
			'is_voucher' => true
		)
	);

	public function beforeRender() {
		parent::beforeRender();

		$this->set('displayName', 'Voucher');
	}

	/**
	 * form fields
	 */
	protected function _adminFormFields() {
		$fields = parent::_adminFormFields();

		$fields[$this->modelClass . '.is_voucher']['type'] = 'hidden';
		$fields[$this->modelClass . '.is_voucher']['value'] = true;

		//Always fixed discounts
		$fields[$this->modelClass . '.discount_type_id']['type'] = 'hidden';
		$fields[$this->modelClass . '.discount_type_id']['value'] = 1;

		//Always one time use
		$fields[$this->modelClass . '.maximum_uses']['type'] = 'hidden';
		$fields[$this->modelClass . '.maximum_uses']['value'] = 1;

		//Always one time use
		unset($fields[$this->modelClass . '.times_used']);

		return $fields;
	}

	/**
	 * Manages an admin edit form for this model
	 *
	 * @param integer $id ID of row to edit
	 * @return void
	 */
	public function admin_edit($id = null) {
		parent::admin_edit($id);

		// If an edit not a create
		if ($id != null) {
			// Add field
			$this->viewVars['fields'] = ArrayUtil::addAfter($this->viewVars['fields'], $this->modelClass . '.currency_id', array(
				$this->modelClass . '.used' => array(
					'label' => "Used?",
					'type' => 'string',
					'displayonly' => true
				)
			));

			if ($this->request->data[$this->modelClass]['times_used'] > 1) {
				$this->request->data[$this->modelClass]['used'] = "Yes - Discount has been used {$this->request->data[$this->modelClass]['times_used']} times.";
			} elseif ($this->request->data[$this->modelClass]['times_used'] == 1) {
				$this->request->data[$this->modelClass]['used'] = "Yes - Discount has been used once.";
			} else {
				$this->request->data[$this->modelClass]['used'] = 'No - Discount has not been used.';
			}
		}
	}
}
